/**
 * External dependencies
 */
import classnames from 'classnames';

/**
 * WordPress dependencies
 */
import {Icon} from '@wordpress/components';
import {blockDefault} from '@wordpress/icons';
import {memo} from '@wordpress/element';

function BlockIcon({icon, showColors = false, className, context}) {
    if (icon?.src === 'block-default') {
        icon = {
            src: blockDefault,
        };
    }

    // @ts-ignore
    const renderedIcon = <Icon icon={icon && icon.src ? icon.src : icon} context={context} />;
    const style = showColors
        ? {
              backgroundColor: icon && icon.background,
              color: icon && icon.foreground,
          }
        : {};

    return (
        <span
            style={style}
            className={classnames('block-editor-block-icon', className, {
                'has-colors': showColors,
            })}
        >
            {renderedIcon}
        </span>
    );
}

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-icon/README.md
 */
export default memo( BlockIcon );